/*------------------------------------------------------------------------------*
 * File Name: MATVarlist.h														*
 * Creation: Soapy 8/10/2003													*
 * Purpose: MATVarList Class													*
 * Copyright (c) OriginLab Corp.	2001										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * 																				*
 *------------------------------------------------------------------------------*/

#ifndef _MATVARLIST_H
#define _MATVARLIST_H 

#include "GridControl.h"

#ifdef IMPORT_MATFILE_WITHOUT_COM
#define STR_MATVARLIST_GRID_COLS _L("Name|Size|Class|Importable")	//column heading
#else
#define STR_MATVARLIST_GRID_COLS _L("Name|Size|Bytes|Class")	//column heading
#endif

#define VS_MATVARLIST_COLS  4     // number of columns
#define VS_MATVARLIST_FIXED_ROWS  1 	// number of fixed rows
#define VS_MATVARLIST_FIXED_COLS  0		// number of fixed columns

/*
	This class is for the display of MATLAB variables in MAT files or MATLAB workspace.
*/

class MATVarList : public GridListControl
{
public:
	void Init(int nID, Dialog& dlg)
	{
		GridListControl::Init(nID, dlg);
		
		SetupTheGrid();
	}
	
	BOOL SetupTheGrid()
	{
		m_flx.FormatString = STR_MATVARLIST_GRID_COLS;
		
		m_flx.Rows = VS_MATVARLIST_FIXED_ROWS;
		m_flx.Cols=VS_MATVARLIST_COLS;
		m_flx.ExtendLastCol=true;
		
		m_flx.FixedRows = VS_MATVARLIST_FIXED_ROWS;
		m_flx.FixedCols = VS_MATVARLIST_FIXED_COLS;		//hide the Row heading
		
		
		m_flx.SelectionMode = flexSelectionListBox;		//select non-continuous rows
		m_flx.AllowSelection = true;
		m_flx.AllowUserResizing = flexResizeColumns;	//allow columns resizing
	
		m_flx.ExplorerBar = flexExSort;
		return TRUE;
	}
		
	// Show or hide the Grid
	BOOL ShowTheGrid( BOOL bShow = TRUE)
	{
		SetVisible(bShow);
		return TRUE;
	}
	
	// Add an item to the list 
	int AddItem(const string& str)
	{
		int	nRow = m_flx.Rows;
		m_flx.AddItem(str);
		return nRow;
	}
	
	// Expand outline, resize to fit, collapse outline
	BOOL ReDraw()
	{
		m_flx.Outline(-1);
	    m_flx.AutoSize(1, 2);
	    m_flx.Outline(1);
	    
	    return TRUE
	}
	
	// Return the number of selected rows
	int SelectedRows()
	{
		return m_flx.SelectedRows;
	}
	
	// Return the row number of the iith selected row
	int SelectedRow(int ii)
	{
		return GetSelectedRow(ii);
	}
	

};

#endif //_MATVARLIST_H